/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.api.predicate.EntityEquipmentPredicate;
import dev.lambdaurora.lambdynlights.api.predicate.EntityTypePredicate;
import dev.lambdaurora.lambdynlights.api.predicate.LightSourceLocationPredicate;
import dev.lambdaurora.lambdynlights.api.utils.CodecUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2040;
import net.minecraft.class_2102;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public record EntityLightSource(EntityPredicate predicate, List<EntityLuminance> luminances) {
    public static final Codec<EntityLightSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.CODEC.fieldOf("match").forGetter(EntityLightSource::predicate), (App)EntityLuminance.LIST_CODEC.fieldOf("luminance").forGetter(EntityLightSource::luminances)).apply((Applicative)instance, EntityLightSource::new));

    public @Range(from=0L, to=15L) int getLuminance(ItemLightSourceManager itemLightSourceManager, class_1297 entity) {
        if (this.predicate.test(entity)) {
            return EntityLuminance.getLuminance(itemLightSourceManager, entity, this.luminances);
        }
        return 0;
    }

    public record EntityPredicate(Optional<EntityTypePredicate> entityType, Optional<LightSourceLocationPredicate> located, Optional<class_2102> effects, Optional<class_2040> flags, Optional<EntityEquipmentPredicate> equipment, Optional<EntityPredicate> vehicle, Optional<EntityPredicate> passenger) {
        public static final Codec<EntityPredicate> CODEC = CodecUtils.recursive("EntityPredicate", codec -> RecordCodecBuilder.create(instance -> instance.group((App)EntityTypePredicate.CODEC.optionalFieldOf("type").forGetter(EntityPredicate::entityType), (App)LightSourceLocationPredicate.CODEC.optionalFieldOf("location").forGetter(EntityPredicate::located), (App)CodecUtils.MOB_EFFECTS_PREDICATE_CODEC.optionalFieldOf("effects").forGetter(EntityPredicate::effects), (App)CodecUtils.ENTITY_FLAGS_PREDICATE_CODEC.optionalFieldOf("flags").forGetter(EntityPredicate::flags), (App)EntityEquipmentPredicate.CODEC.optionalFieldOf("equipment").forGetter(EntityPredicate::equipment), (App)codec.optionalFieldOf("vehicle").forGetter(EntityPredicate::vehicle), (App)codec.optionalFieldOf("passenger").forGetter(EntityPredicate::passenger)).apply((Applicative)instance, EntityPredicate::new)));

        public boolean test(class_1297 entity) {
            if (entity == null) {
                return false;
            }
            if (this.entityType.isPresent() && !this.entityType.get().matches(entity.method_5864())) {
                return false;
            }
            if (this.located.isPresent() && !this.located.get().matches(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321())) {
                return false;
            }
            if (this.effects.isPresent() && !this.effects.get().method_9062(entity)) {
                return false;
            }
            if (this.flags.isPresent() && !this.flags.get().method_8892(entity)) {
                return false;
            }
            if (this.equipment.isPresent() && !this.equipment.get().matches(entity)) {
                return false;
            }
            if (this.vehicle.isPresent() && !this.vehicle.get().test(entity.method_5854())) {
                return false;
            }
            return this.passenger.isEmpty() || entity.method_5685().stream().noneMatch(passenger -> this.passenger.get().test((class_1297)passenger));
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Optional<EntityTypePredicate> entityType = Optional.empty();
            private Optional<LightSourceLocationPredicate> located = Optional.empty();
            private Optional<class_2102> effects = Optional.empty();
            private Optional<class_2040> flags = Optional.empty();
            private Optional<EntityEquipmentPredicate> equipment = Optional.empty();
            private Optional<EntityPredicate> vehicle = Optional.empty();
            private Optional<EntityPredicate> passenger = Optional.empty();

            @NotNull
            public Builder of(@NotNull class_1299<?> type) {
                this.entityType = Optional.of(EntityTypePredicate.of(type));
                return this;
            }

            @NotNull
            public Builder of(class_1299<?> ... types) {
                this.entityType = Optional.of(new EntityTypePredicate((class_6885<class_1299<?>>)class_6885.method_40245(class_1299::method_40124, (Object[])types)));
                return this;
            }

            @NotNull
            public Builder of(@NotNull class_6862<class_1299<?>> tag) {
                this.entityType = Optional.of(EntityTypePredicate.of(tag));
                return this;
            }

            @Contract(value="_ -> this")
            public Builder entityType(@NotNull EntityTypePredicate entityTypePredicate) {
                this.entityType = Optional.of(entityTypePredicate);
                return this;
            }

            @Contract(value="_ -> this")
            public Builder located(@NotNull LightSourceLocationPredicate.Builder builder) {
                this.located = Optional.of(builder.build());
                return this;
            }

            @Contract(value="_ -> this")
            public Builder effects(@NotNull class_2102 effectsPredicate) {
                this.effects = Optional.of(effectsPredicate);
                return this;
            }

            @Contract(value="_ -> this")
            public Builder flags(@NotNull class_2040.class_2041 builder) {
                this.flags = Optional.of(builder.method_8899());
                return this;
            }

            @Contract(value="_ -> this")
            public Builder equipment(@NotNull EntityEquipmentPredicate equipmentPredicate) {
                this.equipment = Optional.of(equipmentPredicate);
                return this;
            }

            @Contract(value="_ -> this")
            public Builder vehicle(@NotNull Builder builder) {
                this.vehicle = Optional.of(builder.build());
                return this;
            }

            @Contract(value="_ -> this")
            public Builder passenger(@NotNull Builder builder) {
                this.passenger = Optional.of(builder.build());
                return this;
            }

            @NotNull
            public EntityPredicate build() {
                return new EntityPredicate(this.entityType, this.located, this.effects, this.flags, this.equipment, this.vehicle, this.passenger);
            }
        }
    }
}

